package plugin.sympathy.rss.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import plugin.sympathy.rss.util.RESOURCE_CONST;

public class OperationUrls
{
    private static final String _CHAR_SET = "UTF-8";
    
    /**
     * デフォルトのUrlsを取得します。
     * @return string
     * @param file
     * @throws UnsupportedEncodingException 
     * */
    public String defaultString(String file ) 
    throws FileNotFoundException, JAXBException, UnsupportedEncodingException
    {
    	return this.marshal(this.defaultUnmarsahl(file),true);
    }
    
    /**
     * デフォルトのUrlsを取得します。
     * @return urls
     * @param file
     * */
    private Urls defaultUnmarsahl(String file)
    throws FileNotFoundException, JAXBException
    {
    	if(file == null || "".equals(file))
    		return null;
	
    	JAXBContext jc = JAXBContext.newInstance ( RESOURCE_CONST.JAXB_CREATE_PACKAGE_RSS_PATH );
    	Unmarshaller u = jc.createUnmarshaller();
    	Class clazz = getClass();
    	Urls url = (Urls)u.unmarshal ( clazz.getResourceAsStream(file) );
    	return url;
    }
    
    /**
     * FilePathからUrlsを取得
     * @return urls
     * @param file
     * */
    public Urls unmarshalFile(String file) 
    throws MalformedURLException, JAXBException
    {
	if(file == null || "".equals(file))
	    return null;
	JAXBContext jc = JAXBContext.newInstance ( RESOURCE_CONST.JAXB_CREATE_PACKAGE_RSS_PATH );
    	Unmarshaller u = jc.createUnmarshaller();
    	return (Urls)u.unmarshal(new File(file).toURL());
    }
    
    /**
     * XMLファイルの文字表現をJaxbを使用し、
     * Objectに変換します。
     * @param contents
     * @return urls
     * @throws UnsupportedEncodingException 
     * */
    public Urls unmarshal ( String contents ) 
    throws FileNotFoundException, JAXBException, UnsupportedEncodingException
    {
    	if(contents == null || "".equals(contents))
    	    return null;
    	
    	contents = new String(contents.getBytes(System.getProperty("file.encoding")) , _CHAR_SET );
	
    	JAXBContext jc = JAXBContext.newInstance ( RESOURCE_CONST.JAXB_CREATE_PACKAGE_RSS_PATH );
    	Unmarshaller u = jc.createUnmarshaller();
    	return (Urls)u.unmarshal ( new ByteArrayInputStream ( contents.getBytes(_CHAR_SET) ) );
    } 
    
    /**
     * Urlsオブジェクトから、文字列を生成します。
     * @param urls
     * @return out
     * @throws UnsupportedEncodingException 
     * */
    public String marshal(Urls urls , boolean isDefault ) 
    throws JAXBException, UnsupportedEncodingException
    {
    	JAXBContext jc = JAXBContext.newInstance ( RESOURCE_CONST.JAXB_CREATE_PACKAGE_RSS_PATH );
    	Marshaller m = jc.createMarshaller();
    	ByteArrayOutputStream out = new ByteArrayOutputStream();
        m.marshal ( urls , out );
        if ( isDefault )
            return new String ( out.toString(_CHAR_SET ) );
        else
            return new String ( out.toString(_CHAR_SET).getBytes ( _CHAR_SET ) , System.getProperty("file.encoding") );
    }
}
