package plugin.sympathy.rss.views.tree;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

import de.nava.informa.core.ItemIF;

import plugin.sympathy.rss.xml.Site;


public class TableLabelProvider extends LabelProvider implements ITableLabelProvider {

	/**
	 * @param element
	 * @param columnIndex
	 * @return image
	 * */
	public Image getColumnImage(Object element, int columnIndex) 
	{
		return null;
	}

	/**
	 * テーブルのセル値を設定する
	 * @param element
	 * @param columnIndex
	 * @return result
	 * */
	public String getColumnText(Object element, int columnIndex) 
	{
		String result = "";
		if ( element instanceof Site)
			result = this.getSiteColumnText((Site)element, columnIndex);
		else if ( element instanceof ItemIF)
			result = this.getItemColumnText((ItemIF)element, columnIndex);
		
		return result;
	}
	
	private String getSiteColumnText ( Site site , int columnIndex)
	{
		String result = "";
		switch ( columnIndex )
		{
			case 0:
				result = site.getName();
		}
		return result;
	}
	
	private String getItemColumnText (ItemIF item , int columnIndex )
	{
		String result = "";
		switch ( columnIndex )
		{
			case 0:
				result = item.getSubject();
				break;
			case 1:
				result = item.getTitle();
				break;
			case 2:
				result = item.getCreator();
				break;
			case 3:
				result = item.getDate().toString();
				break;
		}
		return result;
	}
}
