package plugin.sympathy.rss.views;


import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.*;
import org.eclipse.ui.progress.IProgressService;

import plugin.sympathy.rss.Activator;
import plugin.sympathy.rss.preferences.SymPreferenceConstants;
import plugin.sympathy.rss.util.ExceptionHandler;
import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.util.StringUtil;
import plugin.sympathy.rss.views.tree.DoubleClickListener;
import plugin.sympathy.rss.views.tree.TreeContentProvider;
import plugin.sympathy.rss.views.tree.TableLabelProvider;
import plugin.sympathy.rss.xml.OperationUrls;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;	

/**
 * EclipseのView拡張ポイント
 * */
public class SymRssView extends ViewPart 
{

	/**Preferenceで設定された値*/
	private Urls _urls;
	/**Preferenceで設定された値*/
	private List<Site> _filterList = new ArrayList<Site>();
	/**親のComposite*/
	private Composite _parent;
	/**Action*/
	private Action _refleshAction;
	/**Rssの表示用*/
	private TableTreeViewer _tableTreeViewer;
	/**reflesh中にCacelを押されたときのために元の値を設定しておく*/
	private List<Site> _orgFilterList = new ArrayList<Site>();

	/**
	 * コンストラクタ
	 * intervalの設定
	 * 一定時間毎に再取得処理が実行されるよう設定
	 * */
	public SymRssView()
	{
		this.getUrls();
		Runnable runnable = new Runnable() 
		{
			public void run() 
			{
				Display display = Display.getCurrent();
				if  ( ! display.isDisposed() && ! StringUtil.isNull ( _urls.getInterval() ) && ! "0".equals(_urls.getInterval()))
					display.timerExec ( Integer.parseInt(_urls.getInterval()) , this );
			}
		};
		Display display = Display.getCurrent();
		if  ( ! display.isDisposed() && ! StringUtil.isNull ( _urls.getInterval() ) && ! "0".equals(_urls.getInterval()))
			display.timerExec ( Integer.parseInt(_urls.getInterval()) , runnable );
		
	}
	
	/**
	 * Viewの作成
	 * @param parent
	 * */
	@Override
	public void createPartControl(Composite parent) 
	{
		this._parent = parent;
		
		this.getUrls();
		this._tableTreeViewer = new TableTreeViewer(parent, SWT.NONE | SWT.FULL_SELECTION);
        this.createColumn();
        
        
        this._tableTreeViewer.setContentProvider(new TreeContentProvider(this._urls,parent));
        this._tableTreeViewer.setLabelProvider(new TableLabelProvider());
        this._tableTreeViewer.addDoubleClickListener(new DoubleClickListener(parent));
        
        this.listFilter();
        this._tableTreeViewer.setInput(this._filterList);
        
        this.makeAction();
	}

	@Override
	public void setFocus() 
	{	
	}
	
	/**
	 * カラムの作成
	 * */
	@SuppressWarnings("deprecation")
	private void createColumn()
	{
		Table table = this._tableTreeViewer.getTableTree().getTable();
		
		String[] cols = { RESOURCE_CONST.VIEW_TABLE_COLUMN_SUBJECT , RESOURCE_CONST.VIEW_TABLE_COLUMN_SUBJECT , RESOURCE_CONST.VIEW_TABLE_COLUMN_CREATOR , RESOURCE_CONST.VIEW_TABLE_COLUMN_DATE };
	    for ( int i = 0 ; i < cols.length ; i++ )
	    {
	    	TableColumn col = new TableColumn ( table , SWT.LEFT );
	    	col.setText ( cols[i] );
	    	col.setWidth ( 300 );
	    }
	    
	    table.setHeaderVisible ( true );
	}
	
	/**
	 * Refleshボタンを押下時の動作
	 * */
	private void reflesh() 
	throws CoreException, InterruptedException
	{ 
		IRunnableWithProgress r= new IRunnableWithProgress() {
			
			  public void run(IProgressMonitor monitor) 
			  {
				  monitor.beginTask ( "Getting RSS Feed" , 10 );
				  monitor.subTask("Getting RSS Feed");
				  
				  monitor.setCanceled(true);
				  
				  Display.getDefault().asyncExec(new Runnable()
				  {
					  public void run() 
					  {
						  _orgFilterList.addAll(_filterList);
						  _filterList.clear();
						  getUrls();
						  listFilter();
						  _tableTreeViewer.setInput(_filterList);
					  }
				  });
				  monitor.done();
			  }
		};
		
		IProgressService service = PlatformUI.getWorkbench().getProgressService();
		try
		{
			service.run(true, true, r);
		}
		//Cacelが押された時
		catch (InvocationTargetException e) 
		{
			this._tableTreeViewer.setInput(this._orgFilterList);
		} 

	}
	
	/**
	 * Preferenceで設定した値の取得
	 * */
	private void getUrls()
	{
		try
		{
			this._urls = new OperationUrls().unmarshal(Activator.getDefault().getPreferenceStore().getString(SymPreferenceConstants.P_STRING));
		}
		catch(Exception e)
		{
			new ExceptionHandler().exceptionHandlar(e, this._parent.getShell());
		}
	}
	
	/**
	 * Preferenceで表示対象のもののみ取得する
	 * */
	public void listFilter()
	{
		List <Site>siteList = this._urls.getSite();
		for ( Site site : siteList)
		{
			if ( RESOURCE_CONST.TRUE.equals ( site.getFlag() ) )
				this._filterList.add ( site );
		}
		
	}
	
	/**
	 * Actionの作成
	 * */
	private void makeAction()
	{
		this._refleshAction = new Action()
		{
			public void run() 
			{
				try
				{
					reflesh();
				}
				catch (Exception e) 
				{
					new ExceptionHandler().exceptionHandlar(e,_parent.getShell());
					e.printStackTrace();
				}
			}
		};
		this._refleshAction.setText("reflesh");
		this._refleshAction.setToolTipText("reflesh tooltip");
		this._refleshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(ISharedImages.IMG_OBJS_INFO_TSK));
		
		IActionBars bars = getViewSite().getActionBars();
		IToolBarManager manager = bars.getToolBarManager();
		manager.add(this._refleshAction);
		manager.add(new Separator());
		
	}

}