package plugin.sympathy.rss.util;

public final class StringUtil
{
    /**
     * 可変長配列が全てNullならtrue
     * ひとつでもNullでないものが含まれていたらfalse
     * @param values
     * @return boolean
     * */
    public static boolean isAllNull ( String...values )
    {
	for ( String value : values )
	{
	    if ( ! StringUtil.isNull ( value ) )
		return false;
	}
	return true;
    }
    
    /**
     * 可変長配列中にひとつでもNullが入っていればtrue
     * ひとつも入っていなかったらfalse
     * @param values
     * @return boolean
     * */
    public static boolean isInNull( String...values )
    {
	for ( String value : values )
	{
	    if ( StringUtil.isNull ( value ) )
		return true;
	}
	return false;
    }
    
    /**
     * 文字列がNullならtrue
     * Nullでばければfalse
     * @param value
     * @return boolean
     * */
    public static boolean isNull ( String value )
    {
	if ( value == null || value.equals ( "" ) || value.length() == 0)
	    return true;
	return false;
    }
}
