package plugin.sympathy.rss.preferences.table;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

import plugin.sympathy.rss.xml.OperationUrls;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;

public class SymDropListener implements DropTargetListener
{
    private SymView _view;
    private OperationUrls _ope;
    
    public SymDropListener ( SymView view)
    {
	this._view = view;
	this._ope = new OperationUrls(); 
    }
    
    public void dragEnter(DropTargetEvent event){}
    public void dragLeave(DropTargetEvent event){}
    public void dragOperationChanged(DropTargetEvent event){}
    public void dragOver(DropTargetEvent event){}
    
    /**
     * PreferenceのTable部分にDropされたときに実行される
     * @param event
     * */
    public void drop(DropTargetEvent event)
    {
	List<Site> siteList = new ArrayList<Site>();
	
	if ( event.data instanceof String[] )
	{
	    String[] files = (String[])event.data;
	    for ( String file : files)
	    {
		siteList.addAll(this.getSiteList(file));
	    }
	    
	    if ( ! siteList.isEmpty() )
		this._view.importSite(siteList);
	}
	
    }
    public void dropAccept(DropTargetEvent event){}
    
    /**
     * FilePathからSiteListを生成
     * @param file
     * @return siteList
     * */
    private List<Site> getSiteList ( String file )
    {
	Urls urls = null;
	try
	{
	    urls = this._ope.unmarshalFile(file);
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	}
	
	if(urls == null)
	    return null;
	
	return urls.getSite();
    }

}
