package plugin.sympathy.rss.preferences;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;

import plugin.sympathy.rss.Activator;
import plugin.sympathy.rss.xml.OperationUrls;

/**
 * Class used to initialize default preference values.
 */
public class SymRssPreferenceInitializer extends AbstractPreferenceInitializer {

    private static final String _CHAR_SET = "UTF-8";
	public void initializeDefaultPreferences() 
	{
	    IPreferenceStore store = Activator.getDefault().getPreferenceStore();
	    try
	    {
		String str = new OperationUrls().defaultString("/xml/Rss.xml");
	    	store.setDefault(SymPreferenceConstants.P_STRING , new String(str.getBytes ( _CHAR_SET ) , System.getProperty("file.encoding")));
	    } 
	    catch (Exception e)
	    {
	    	e.printStackTrace();
	    }
	}

}
