/*
 * Decompiled with CFR 0.152.
 */
package plugin.sympathy.rss.views.tree;

import de.nava.informa.core.ItemIF;
import de.nava.informa.core.ParseException;
import java.io.IOException;
import java.util.List;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import plugin.sympathy.rss.connect.RssConnect;
import plugin.sympathy.rss.util.ExceptionHandler;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;

public class TreeContentProvider
implements ITreeContentProvider {
    private Urls _urls;
    private Composite _parent;

    public TreeContentProvider(Urls urls, Composite parent) {
        this._urls = urls;
        this._parent = parent;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof List) {
            return ((List)parent).toArray();
        }
        if (parent instanceof Site) {
            try {
                return this.getRss((Site)parent);
            }
            catch (Exception e) {
                new ExceptionHandler().exceptionHandlar(e, this._parent.getShell());
                e.printStackTrace();
            }
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.getChildren(element).length > 0;
    }

    public Object[] getElements(Object input) {
        return this.getChildren(input);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    private Object[] getRss(Site site) throws IOException, ParseException {
        List<ItemIF> list = new RssConnect(this._urls.getProxyIp(), this._urls.getProxyPort()).getRss(site.getUrl());
        return list.toArray();
    }
}

