/*
 * Decompiled with CFR 0.152.
 */
package plugin.sympathy.rss.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import plugin.sympathy.rss.Activator;
import plugin.sympathy.rss.util.ExceptionHandler;
import plugin.sympathy.rss.util.RESOURCE_CONST;
import plugin.sympathy.rss.util.StringUtil;
import plugin.sympathy.rss.views.tree.DoubleClickListener;
import plugin.sympathy.rss.views.tree.TableLabelProvider;
import plugin.sympathy.rss.views.tree.TreeContentProvider;
import plugin.sympathy.rss.xml.OperationUrls;
import plugin.sympathy.rss.xml.Site;
import plugin.sympathy.rss.xml.Urls;

public class SymRssView
extends ViewPart {
    private Urls _urls;
    private List<Site> _filterList = new ArrayList<Site>();
    private Composite _parent;
    private Action _refleshAction;
    private TableTreeViewer _tableTreeViewer;

    public SymRssView() {
        this.getUrls();
        Runnable runnable = new Runnable(){

            public void run() {
                Display display = Display.getCurrent();
                if (!(display.isDisposed() || StringUtil.isNull(SymRssView.this._urls.getInterval()) || "0".equals(SymRssView.this._urls.getInterval()))) {
                    display.timerExec(Integer.parseInt(SymRssView.this._urls.getInterval()), (Runnable)this);
                }
            }
        };
        Display display = Display.getCurrent();
        if (!(display.isDisposed() || StringUtil.isNull(this._urls.getInterval()) || "0".equals(this._urls.getInterval()))) {
            display.timerExec(Integer.parseInt(this._urls.getInterval()), runnable);
        }
    }

    public void createPartControl(Composite parent) {
        this._parent = parent;
        this.getUrls();
        this._tableTreeViewer = new TableTreeViewer(parent);
        this.createColumn();
        this._tableTreeViewer.setContentProvider((IContentProvider)new TreeContentProvider(this._urls, parent));
        this._tableTreeViewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this._tableTreeViewer.addDoubleClickListener((IDoubleClickListener)new DoubleClickListener(parent));
        this.listFilter();
        this._tableTreeViewer.setInput(this._filterList);
        this.makeAction();
    }

    public void setFocus() {
    }

    private void createColumn() {
        Table table = this._tableTreeViewer.getTableTree().getTable();
        String[] cols = new String[]{RESOURCE_CONST.VIEW_TABLE_COLUMN_SUBJECT, RESOURCE_CONST.VIEW_TABLE_COLUMN_SUBJECT, RESOURCE_CONST.VIEW_TABLE_COLUMN_CREATOR, RESOURCE_CONST.VIEW_TABLE_COLUMN_DATE};
        int i = 0;
        while (i < cols.length) {
            TableColumn col = new TableColumn(table, 16384);
            col.setText(cols[i]);
            col.setWidth(300);
            ++i;
        }
        table.setHeaderVisible(true);
    }

    private void reflesh() {
        this._filterList.clear();
        this.getUrls();
        this.listFilter();
        this._tableTreeViewer.setInput(this._filterList);
    }

    private void getUrls() {
        try {
            this._urls = new OperationUrls().unmarshal(Activator.getDefault().getPreferenceStore().getString("stringPreference"));
        }
        catch (Exception e) {
            new ExceptionHandler().exceptionHandlar(e, this._parent.getShell());
        }
    }

    public void listFilter() {
        List<Site> siteList = this._urls.getSite();
        for (Site site : siteList) {
            if (!RESOURCE_CONST.TRUE.equals(site.getFlag())) continue;
            this._filterList.add(site);
        }
    }

    private void makeAction() {
        this._refleshAction = new Action(){

            public void run() {
                SymRssView.this.reflesh();
            }
        };
        this._refleshAction.setText("reflesh");
        this._refleshAction.setToolTipText("reflesh tooltip");
        this._refleshAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this._refleshAction);
        manager.add((IContributionItem)new Separator());
    }
}

