/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.util;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import jp.sourceforge.sxdbutils.util.OthersUtils;

public class QueryUtil {
    private static final BigDecimal BIGDECIMAL_ONE = new BigDecimal("1");

    private QueryUtil() {
    }

    public static boolean isBlank(CharSequence chars) {
        int len;
        if (chars == null || (len = chars.length()) == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(chars.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(CharSequence chars) {
        if (chars == null) {
            return true;
        }
        return chars.length() == 0;
    }

    public static int replace(StringBuilder builder, String from, String to) {
        return QueryUtil.replace(builder, from, to, 0);
    }

    public static int replace(StringBuilder builder, String from, String to, int fromIndex) {
        int start = builder.indexOf(from, fromIndex);
        if (start == -1) {
            return -1;
        }
        int end = start + from.length();
        if (builder.length() < end) {
            return -1;
        }
        builder.replace(start, end, to);
        return start + to.length();
    }

    public static int replaceAll(StringBuilder builder, String from, String to) {
        int i = 0;
        int index = 0;
        while ((index = QueryUtil.replace(builder, from, to, index)) != -1) {
            ++i;
        }
        return i;
    }

    public static String sqlDateFormat(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(date);
    }

    public static String sqlDateFormat(Calendar cal) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(cal);
    }

    public static boolean appendLikeEscapeOracle(StringBuilder buffer, String text) {
        if (OthersUtils.isBlank(text)) {
            return false;
        }
        boolean escape = false;
        block7: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '%': {
                    buffer.append("\\%");
                    escape = true;
                    continue block7;
                }
                case '_': {
                    buffer.append("\\_");
                    escape = true;
                    continue block7;
                }
                case '\\': {
                    buffer.append("\\\\");
                    escape = true;
                    continue block7;
                }
                case '\uff05': {
                    buffer.append("\\\uff05");
                    escape = true;
                    continue block7;
                }
                case '\uff3f': {
                    buffer.append("\\\uff3f");
                    escape = true;
                    continue block7;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return escape;
    }

    public static Object getNextVersion(Object current) {
        if (current instanceof Integer) {
            Integer i = (Integer)current;
            return new Integer(i + 1);
        }
        if (current instanceof Long) {
            Long l = (Long)current;
            return new Long(l + 1L);
        }
        if (current instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)current;
            return bd.add(BIGDECIMAL_ONE);
        }
        if (current instanceof Date) {
            return new Date();
        }
        return null;
    }
}

