/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;
import jp.sourceforge.sxdbutils.meta.VersionColumnPersistenceEntry;
import jp.sourceforge.sxdbutils.query.AttributeQueryFactory;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.util.OthersUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeQueryFactoryBuilder<E> {
    private static final NameMapping DEFAULT_NAME_MAPPING = new ColumnNameMapping();
    protected String tableName;
    protected final Class<E> baseClass;
    protected final NameMapping nameMapping;
    protected Set<String> whereKeyColumnSet;
    protected String versionColumnName;
    protected Map<String, Object> columnTypeMap = new HashMap<String, Object>();
    protected Set<String> excludeColumnSet = new HashSet<String>();

    public AttributeQueryFactoryBuilder(Class<E> baseClass) {
        this(baseClass, DEFAULT_NAME_MAPPING);
    }

    public AttributeQueryFactoryBuilder(Class<E> baseClass, NameMapping nameMapping) {
        this.baseClass = baseClass;
        this.nameMapping = nameMapping;
        this.tableName = OthersUtils.getShortClassName(baseClass);
    }

    private boolean isWhereKey(String columnName) {
        if (this.whereKeyColumnSet == null) {
            return false;
        }
        return this.whereKeyColumnSet.contains(columnName.toLowerCase());
    }

    public QueryFactory<E> buildUpdate() {
        PersistenceEntry[] beanColumns = this.toPersistenceEntries();
        StringBuilder columnBuffer = new StringBuilder(beanColumns.length * 7);
        ArrayList<PersistenceEntry> updateColumnProperties = new ArrayList<PersistenceEntry>();
        ArrayList<PersistenceEntry> whereColumnProperties = new ArrayList<PersistenceEntry>();
        columnBuffer.append("update ").append(this.tableName).append(" set ");
        boolean flg = false;
        for (int i = 0; i < beanColumns.length; ++i) {
            PersistenceEntry beanColumn = beanColumns[i];
            if (this.isWhereKey(beanColumn.getColumnName())) {
                whereColumnProperties.add(beanColumn);
                continue;
            }
            if (flg) {
                columnBuffer.append(',');
            } else {
                flg = true;
            }
            columnBuffer.append(beanColumn.getColumnName()).append("=?");
            if (this.versionColumnName != null && this.versionColumnName.equalsIgnoreCase(beanColumn.getColumnName())) {
                whereColumnProperties.add(beanColumn);
                updateColumnProperties.add(new VersionColumnPersistenceEntry(beanColumn));
                continue;
            }
            updateColumnProperties.add(beanColumn);
        }
        StringBuilder whereBuffer = null;
        if (!whereColumnProperties.isEmpty()) {
            Iterator iterator = whereColumnProperties.iterator();
            while (iterator.hasNext()) {
                if (whereBuffer == null) {
                    whereBuffer = new StringBuilder(" where ");
                } else {
                    whereBuffer.append(" and ");
                }
                PersistenceEntry columnProperty = (PersistenceEntry)iterator.next();
                whereBuffer.append(columnProperty.getColumnName()).append("=?");
            }
        }
        ArrayList<PersistenceEntry> list = new ArrayList<PersistenceEntry>(updateColumnProperties);
        list.addAll(whereColumnProperties);
        if (whereBuffer != null) {
            columnBuffer.append((CharSequence)whereBuffer);
        }
        String sql = columnBuffer.toString();
        return new AttributeQueryFactory(sql, list.toArray(new PersistenceEntry[list.size()]));
    }

    public QueryFactory<E> buildInsert() {
        PersistenceEntry[] entries = this.toPersistenceEntries();
        StringBuilder columnBuffer = new StringBuilder(entries.length * 7);
        StringBuilder valueBuffer = new StringBuilder(entries.length * 2);
        columnBuffer.append("insert into ").append(this.tableName).append("(");
        valueBuffer.append(" values ( ");
        boolean flg = false;
        for (int i = 0; i < entries.length; ++i) {
            if (flg) {
                columnBuffer.append(',');
                valueBuffer.append(',');
            } else {
                flg = true;
            }
            PersistenceEntry columnProperty = entries[i];
            columnBuffer.append(columnProperty.getColumnName());
            valueBuffer.append('?');
        }
        columnBuffer.append(" ) ");
        valueBuffer.append(" ) ");
        String sql = columnBuffer.append((CharSequence)valueBuffer).toString();
        return new AttributeQueryFactory(sql, entries);
    }

    public QueryFactory<E> buildDelete() {
        PersistenceEntry[] entries = this.toPersistenceEntries();
        StringBuilder deleteBuffer = new StringBuilder(entries.length * 7);
        ArrayList<PersistenceEntry> whereEntries = new ArrayList<PersistenceEntry>();
        deleteBuffer.append("delete from ").append(this.tableName);
        for (int i = 0; i < entries.length; ++i) {
            PersistenceEntry entry = entries[i];
            if (this.isWhereKey(entry.getColumnName())) {
                whereEntries.add(entry);
                continue;
            }
            if (this.versionColumnName == null || !this.versionColumnName.equalsIgnoreCase(entry.getColumnName())) continue;
            whereEntries.add(entry);
        }
        StringBuilder whereBuffer = null;
        if (!whereEntries.isEmpty()) {
            Iterator iterator = whereEntries.iterator();
            while (iterator.hasNext()) {
                if (whereBuffer == null) {
                    whereBuffer = new StringBuilder(" where ");
                } else {
                    whereBuffer.append(" and ");
                }
                PersistenceEntry entry = (PersistenceEntry)iterator.next();
                whereBuffer.append(entry.getColumnName()).append("=?");
            }
        }
        if (whereBuffer != null) {
            deleteBuffer.append((CharSequence)whereBuffer);
        }
        String sql = deleteBuffer.toString();
        return new AttributeQueryFactory(sql, whereEntries.toArray(new PersistenceEntry[whereEntries.size()]));
    }

    protected abstract PersistenceEntry[] toPersistenceEntries();

    protected ValueType getValueType(AttributeDescpriotr attributeDescpriotr, Integer sqlType) {
        return sqlType == null ? TypeMappings.getValueType(attributeDescpriotr.getType()) : TypeMappings.getValueType(attributeDescpriotr.getType(), sqlType);
    }
}

