/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.mapping;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.mapping.OverwriteNameMapping;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstantAnnoNameMapping<E>
implements NameMapping {
    private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();
    private static final String ANNOTATION_SUFFIC = "_COLUMN";
    protected final OverwriteNameMapping delegateNameMapping;

    public ConstantAnnoNameMapping(Class<E> beanClass) {
        this(beanClass, DEFAULT_COMVERSION);
    }

    public ConstantAnnoNameMapping(Class<E> beanClass, NameMapping defaultNameMapping) {
        HashMap<String, String> columnToPropertyMap = new HashMap<String, String>();
        Field[] fields = this.getAnnotationFields(beanClass);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String propertyName = ReflectionUtil.removalSuffixFieldName(field, ANNOTATION_SUFFIC);
            String columnName = this.getColumnNameFromAnnotation(field);
            columnToPropertyMap.put(propertyName, columnName);
        }
        this.delegateNameMapping = new OverwriteNameMapping(columnToPropertyMap, defaultNameMapping);
    }

    protected final String getColumnNameFromAnnotation(Field field) {
        return ReflectionUtil.getString(field);
    }

    protected final Field[] getAnnotationFields(Class<E> beanClass) {
        ArrayList<Field> list = new ArrayList<Field>();
        this.readAnnotationFieldsToList(beanClass, list);
        return list.toArray(new Field[list.size()]);
    }

    protected void readAnnotationFieldsToList(Class<? super E> beanClass, List<Field> list) {
        if ("java.lang.Object".equals(beanClass.getName())) {
            return;
        }
        this.readAnnotationFieldsToList(beanClass.getSuperclass(), list);
        Field[] fields = beanClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!this.isColumnAnnotation(field)) continue;
            list.add(field);
        }
    }

    @Override
    public String toIntermediateNameFromAttrName(String bindObjectName) {
        return this.delegateNameMapping.toIntermediateNameFromAttrName(bindObjectName);
    }

    @Override
    public final Map<String, String> createIntermediateMap() {
        return new CaseInsensitiveHashMap<String>();
    }

    @Override
    public String toIntermediateNameFromColumnName(String columnName) {
        return this.delegateNameMapping.toIntermediateNameFromColumnName(columnName);
    }

    @Override
    public String toColumnNameFromAttrName(String bindObjectName) {
        return this.delegateNameMapping.toColumnNameFromAttrName(bindObjectName);
    }

    private boolean isColumnAnnotation(Field field) {
        if (!ReflectionUtil.isPublicStaticFinalString(field)) {
            return false;
        }
        return field.getName().endsWith(ANNOTATION_SUFFIC);
    }
}

