package jp.sourceforge.sxdbutils.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;

public class DateTimestampType extends AbstractValueType {
	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		Timestamp ts = rset.getTimestamp(columnIndex);
		if (ts == null)
			return null;
		return new java.util.Date(((ts.getTime() / 1000) * 1000) + (ts.getNanos() / 1000000));
	}

	public Object toBindParameterValue(Object value) {
		return value == null ? null : new Timestamp(((Date) value).getTime());
	}

}
