package jp.sourceforge.sxdbutils.template;

import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;

public interface SelectTemplate<E> {

	E executeQueryToBean(Query query) throws SQLException;

	List<E> executeQueryToEntityList(Query query) throws SQLException;

	<X extends E> X executeQueryToEntity(Query query, Class<X> entityClass) throws SQLException;

	<X extends E> List<X> executeQueryToEntityList(Query query, Class<X> entityClass) throws SQLException;

}
