package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.dbutils.ResultSetHandler;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.SxQueryRunner;
import jp.sourceforge.sxdbutils.handlers.ListHandler;
import jp.sourceforge.sxdbutils.handlers.SingleHandler;
import jp.sourceforge.sxdbutils.processors.MapRowProcessor;
import jp.sourceforge.sxdbutils.processors.ValueRowProcessor;

public abstract class AbstractQueryTemplate implements QueryTemplate {

	protected abstract Connection getConnection() throws SQLException;

	public Map<String, Object> executeQueryToMap(Query query) throws SQLException {
		ResultSetHandler<Map<String, Object>> handler = new SingleHandler<Map<String, Object>>(
				new MapRowProcessor());
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

	public List<Map<String, Object>> executeQueryToMapList(Query query) throws SQLException {
		ResultSetHandler<List<Map<String, Object>>> handler = new ListHandler<Map<String, Object>>(
				new MapRowProcessor());
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

	public <V> V executeQueryToValue(Query query, String columnName, Class<V> type) throws SQLException {
		ResultSetHandler<V> handler = new SingleHandler<V>(new ValueRowProcessor<V>(columnName, type));
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

	public <V> List<V> executeQueryToValueList(Query query, String columnName, Class<V> type) throws SQLException {
		ResultSetHandler<List<V>> handler = new ListHandler<V>(new ValueRowProcessor<V>(columnName, type));
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query, handler);
	}

}
