package jp.sourceforge.sxdbutils.rstable;

import java.io.IOException;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.util.OthersUtils;

public class ClobToStringColumn extends AbstractCharacterColumn {

	public ClobToStringColumn(int columnIndex, ResultColumnMetaData columnMeta) {
		super(columnIndex, columnMeta);
	}

	public Object valueOf(ResultSet rset) throws SQLException {
		Reader reader = null;
		try {
			reader = rset.getCharacterStream(columnIndex + 1);
			if (reader == null)
				return null;
			return OthersUtils.toString(reader);
		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			OthersUtils.closeQuietly(reader);
		}
	}

}
