package jp.sourceforge.sxdbutils.rstable;

import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

public class BasicResultColumnRepository implements ResultColumnRepository {
	final Map<String, ResultColumn> resultColumnMap = new HashMap<String, ResultColumn>();
	final ResultColumn[] resultColumns;

	public BasicResultColumnRepository(ResultColumn[] resultColumns) {
		this.resultColumns = resultColumns;
		for (int i = 0; i < resultColumns.length; i++) {
			ResultColumn resultColumn = resultColumns[i];
			if (!resultColumnMap.containsKey(resultColumn.getColumnName()))
				resultColumnMap.put(resultColumn.getColumnName(), resultColumn);
		}
	}

	public ResultColumn getResultColumn(String columnLabel) {
		ResultColumn result = (ResultColumn) resultColumnMap.get(columnLabel.toUpperCase());
		if (result == null) {
			throw new NoSuchElementException(columnLabel + " is not found.");
		}
		return result;
	}

	public ResultColumn getResultColumn(int columnIndex) {
		return resultColumns[columnIndex];
	}

	public int size() {
		return resultColumns.length;
	}
}
