package jp.sourceforge.sxdbutils.rstable;

import java.sql.ResultSet;
import java.sql.SQLException;

public abstract class AbstractColumn implements ResultColumn {

	protected final ResultColumnMetaData columnMetaData;
	protected final int columnIndex;

	public AbstractColumn(int columnIndex, ResultColumnMetaData columnMeta) {
		super();
		this.columnIndex = columnIndex;
		this.columnMetaData = columnMeta;
	}

	protected abstract Object valueOf(ResultSet rset) throws SQLException;

	public Object getValue(ResultSet rs) throws SQLException {
		return valueOf(rs);
	}

	public ResultColumnMetaData getColumnMetaData() {
		return columnMetaData;
	}

	public int getColumnIndex() {
		return columnIndex;
	}

	public String getColumnName() {
		return columnMetaData.getColumnName();
	}
}
