package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.commons.dbutils.ResultSetHandler;

import jp.sourceforge.sxdbutils.SxRowProcessor;

/**
 * 最初の1行のみを処理するハンドラです。 1行も取得できなかった場合はnullを返します。
 * 
 * @author chinpei
 * 
 */
public class SingleHandler<S> implements ResultSetHandler<S> {

	protected final SxRowProcessor<S> processor;

	public SingleHandler(SxRowProcessor<S> processor) {
		this.processor = processor;
	}

	protected SxRowProcessor<S> getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。" + "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}

	public S handle(ResultSet rs) throws SQLException {
		if (rs.next()) {
			SxRowProcessor<S> proc = getProcessor();
			proc.init(rs.getMetaData());
			return proc.process(rs);
		}
		return null;

	}

}
