package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

import org.apache.commons.dbutils.ResultSetHandler;

import jp.sourceforge.sxdbutils.SxRowProcessor;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class SetHandler<S> implements ResultSetHandler<Set<S>> {

	protected final SxRowProcessor<S> processor;

	public SetHandler(SxRowProcessor<S> processor) {
		this.processor = processor;
	}

	protected SxRowProcessor<S> getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。" + "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}

	public Set<S> handle(ResultSet rs) throws SQLException {
		Set<S> rows = createSet();
		if (rs.next()) {
			SxRowProcessor<S> proc = getProcessor();
			proc.init(rs.getMetaData());
			do {
				rows.add(proc.process(rs));
			} while (rs.next());
		}
		return rows;
	}

	private Set<S> createSet() {
		return new HashSet<S>();
	}

}
