package jp.sourceforge.sxdbutils.extras.dao;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.processors.BeanRowProcessor;

public abstract class AbstractBeanSelectTemplate<E> extends AbstractAttributeSelectTemplate<E> {
	protected abstract Class<E> getEntityClass();

	protected NameMapping getNameMapping() {
		return new ColumnNameMapping();
	}

	@Override
	protected <X extends E> SxRowProcessor<X> createRowProcessor(Class<X> entityClass) {
		return new BeanRowProcessor<X>(entityClass, getNameMapping());
	}

}
