/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import jp.sourceforge.sxdbutils.util.DatabaseColumnInfo;
import org.apache.commons.dbutils.DbUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseMetaDataUtil {
    private DatabaseMetaDataUtil() {
    }

    public static Collection<String> getPrimaryKeyNames(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        String schema = null;
        int index = tableName.indexOf(46);
        if (index >= 0) {
            schema = tableName.substring(0, index);
            tableName = tableName.substring(index + 1);
        }
        String convertedTableName = DatabaseMetaDataUtil.convertIdentifier(dbMetaData, tableName);
        Collection<String> result = DatabaseMetaDataUtil.getPrimaryKeyNames(dbMetaData, DatabaseMetaDataUtil.convertIdentifier(dbMetaData, schema), convertedTableName);
        if (!result.isEmpty()) {
            return result;
        }
        result = DatabaseMetaDataUtil.getPrimaryKeyNames(dbMetaData, schema, tableName);
        if (!result.isEmpty()) {
            return result;
        }
        if (schema != null) {
            result = DatabaseMetaDataUtil.getPrimaryKeyNames(dbMetaData, null, convertedTableName);
            if (!result.isEmpty()) {
                return result;
            }
            result = DatabaseMetaDataUtil.getPrimaryKeyNames(dbMetaData, null, tableName);
        }
        return result;
    }

    public static Collection<String> getPrimaryKeyNames(DatabaseMetaData dbMetaData, String schema, String tableName) {
        ArrayList<String> result = new ArrayList<String>();
        ResultSet rs = null;
        try {
            rs = dbMetaData.getPrimaryKeys(null, schema, tableName);
            while (rs.next()) {
                result.add(rs.getString(4));
            }
        }
        catch (SQLException ex) {
            try {
                throw new RuntimeException(ex);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(rs);
                throw throwable;
            }
        }
        DbUtils.closeQuietly((ResultSet)rs);
        return result;
    }

    public static Collection<DatabaseColumnInfo> getColumnInfos(DatabaseMetaData dbMetaData, String tableName) throws SQLException {
        String schema = null;
        int index = tableName.indexOf(46);
        if (index >= 0) {
            schema = tableName.substring(0, index);
            tableName = tableName.substring(index + 1);
        }
        String convertedTableName = DatabaseMetaDataUtil.convertIdentifier(dbMetaData, tableName);
        Collection<DatabaseColumnInfo> result = DatabaseMetaDataUtil.getColumnInfos(dbMetaData, DatabaseMetaDataUtil.convertIdentifier(dbMetaData, schema), convertedTableName);
        if (!result.isEmpty()) {
            return result;
        }
        result = DatabaseMetaDataUtil.getColumnInfos(dbMetaData, schema, tableName);
        if (!result.isEmpty()) {
            return result;
        }
        if (schema != null) {
            result = DatabaseMetaDataUtil.getColumnInfos(dbMetaData, null, convertedTableName);
            if (!result.isEmpty()) {
                return result;
            }
            result = DatabaseMetaDataUtil.getColumnInfos(dbMetaData, null, tableName);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection<DatabaseColumnInfo> getColumnInfos(DatabaseMetaData dbMetaData, String schema, String tableName) throws SQLException {
        ArrayList<DatabaseColumnInfo> result = new ArrayList<DatabaseColumnInfo>();
        ResultSet rs = null;
        try {
            rs = dbMetaData.getColumns(null, schema, tableName, null);
            while (rs.next()) {
                DatabaseColumnInfo info = new DatabaseColumnInfo();
                info.setColumnName(rs.getString(4));
                info.setColumnSize(rs.getInt(7));
                info.setDataType(rs.getInt(5));
                info.setDecimalDigits(rs.getInt(9));
                info.setTypeName(rs.getString(6));
                result.add(info);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(rs);
            throw throwable;
        }
        DbUtils.closeQuietly((ResultSet)rs);
        return result;
    }

    public static String convertIdentifier(DatabaseMetaData dbMetaData, String identifier) throws SQLException {
        if (identifier == null) {
            return null;
        }
        if (!dbMetaData.supportsMixedCaseIdentifiers()) {
            if (dbMetaData.storesUpperCaseIdentifiers()) {
                return identifier.toUpperCase();
            }
            return identifier.toLowerCase();
        }
        return identifier;
    }
}

