/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueRowProcessor<V>
implements SxRowProcessor<V> {
    private int columnIndex;
    private String columnName;
    private Class<V> type;
    private ValueType valueType;

    public ValueRowProcessor(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public ValueRowProcessor(String columnName) {
        this.columnName = columnName;
    }

    public ValueRowProcessor(int columnIndex, Class<V> type) {
        this.columnIndex = columnIndex;
        this.type = type;
    }

    public ValueRowProcessor(String columnName, Class<V> type) {
        this.columnName = columnName;
        this.type = type;
    }

    @Override
    public V process(ResultSet rs) throws SQLException {
        return (V)this.valueType.getValue(rs, this.columnIndex);
    }

    @Override
    public void init(ResultSetMetaData rsmd) throws SQLException {
        if (this.columnName != null) {
            boolean exists = false;
            int i = 0;
            int index = 1;
            while (i < rsmd.getColumnCount()) {
                if (this.columnName.equalsIgnoreCase(rsmd.getColumnLabel(index))) {
                    this.columnIndex = index;
                    exists = true;
                    break;
                }
                ++i;
                ++index;
            }
            if (!exists) {
                throw new SQLException("\u6307\u5b9a\u3055\u308c\u305f\u30ab\u30e9\u30e0\u540d\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002columnName=" + this.columnName);
            }
        }
        this.valueType = this.getValueType(rsmd.getColumnType(this.columnIndex));
    }

    protected ValueType getValueType(int sqlType) {
        return this.type == null ? TypeMappings.getValueType(sqlType) : TypeMappings.getValueType(this.type, sqlType);
    }
}

