/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.meta;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Map;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAttributeDescpritor
implements AttributeDescpriotr {
    private final Method setter;
    private final Method getter;
    private final String name;
    private final Class<?> type;

    public static void putDescriptorToMap(Class<?> clazz, Map<String, AttributeDescpriotr> descriptorMap) {
        if ("java.lang.Object".equals(clazz.getName())) {
            return;
        }
        PropertyAttributeDescpritor.putDescriptorToMap(clazz.getSuperclass(), descriptorMap);
        PropertyDescriptor[] propertyDescriptors = ReflectionUtil.propertyDescriptors(clazz);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor propertyDescriptor = propertyDescriptors[i];
            descriptorMap.put(propertyDescriptor.getName(), new PropertyAttributeDescpritor(propertyDescriptor));
        }
    }

    public PropertyAttributeDescpritor(PropertyDescriptor pd) {
        this.setter = pd.getWriteMethod();
        this.getter = pd.getReadMethod();
        this.name = pd.getName();
        this.type = pd.getPropertyType();
    }

    @Override
    public Object read(Object object) {
        return this.getter == null ? null : ReflectionUtil.invoke(object, this.getter);
    }

    @Override
    public void write(Object object, Object attrValue) {
        if (this.setter != null) {
            ReflectionUtil.invoke(object, this.setter, attrValue);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isReadable() {
        return this.getter != null;
    }

    @Override
    public boolean isWriteable() {
        return this.setter != null;
    }
}

