package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.util.OthersUtils;

public class BooleanNumericType extends AbstractValueType {

	private static final BigDecimal TRUE = new BigDecimal("1");
	private static final BigDecimal FALSE = new BigDecimal("0");
	private final boolean primitive;

	public BooleanNumericType(boolean primitive) {
		this.primitive = primitive;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see dbutilsx.types.ValueType#getValue(java.sql.ResultSet, int)
	 */
	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {

		BigDecimal bd = rset.getBigDecimal(columnIndex);
		if (bd == null)
			return primitive ? Boolean.FALSE : null;
		return OthersUtils.toBooleanObject(bd.intValue());
	}

	public Object toBindParameterValue(Object value) {
		return ((Boolean) value).booleanValue() ? TRUE : FALSE;
	}

}
