package jp.sourceforge.sxdbutils.query;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * INSERT文の {@link Query}を作成するためのビルダーです。
 * @author chinpei
 *
 */
public class SimpleInsertBuilder implements QueryBuilder {
	private final String tableName;

	public SimpleInsertBuilder(String tableName) {
		this.tableName = tableName;
	}

	private Map<String, Object> entries = new LinkedHashMap<String, Object>();

	public SimpleInsertBuilder add(String columnName, Object value) {
		entries.put(columnName, value);
		return this;
	}

	public SimpleInsertBuilder addAll(Map<String, Object> map) {
		for (Iterator<Map.Entry<String, Object>> iterator = map.entrySet().iterator(); iterator.hasNext();) {
			Map.Entry<String, Object> entry = iterator.next();
			entries.put(entry.getKey(), entry.getValue());
		}
		return this;
	}

	public SimpleInsertBuilder add(String columnName, int value) {
		return add(columnName, new Integer(value));
	}

	public SimpleInsertBuilder add(String columnName, long value) {
		return add(columnName, new Long(value));
	}

	public SimpleInsertBuilder add(String columnName, double value) {
		return add(columnName, new Double(value));
	}

	public SimpleInsertBuilder add(String columnName, float value) {
		return add(columnName, new Float(value));
	}

	public SimpleInsertBuilder add(String columnName, short value) {
		return add(columnName, new Short(value));
	}

	public SimpleInsertBuilder add(String columnName, byte value) {
		return add(columnName, new Byte(value));
	}

	public SimpleInsertBuilder add(String columnName, char value) {
		return add(columnName, String.valueOf(value));
	}

	public Query toQuery() {
		SimpleQueryBuilder builder = new SimpleQueryBuilder(256);
		builder.append("insert into ").append(tableName).append(" (");

		StringBuffer valuesPart = new StringBuffer(" values( ");

		boolean flg = false;
		for (Iterator<Map.Entry<String,Object>> iterator = entries.entrySet().iterator(); iterator.hasNext();) {
			Map.Entry<String,Object> entry =  iterator.next();
			if (flg) {
				builder.append(',');
				valuesPart.append(',');
			}
			flg = true;
			builder.append((String) entry.getKey()).bind(entry.getValue());
			valuesPart.append('?');
		}
		builder.append(" ) ").append(valuesPart).append(")");
		return builder.toQuery();
	}
}
