/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.template.EntityPersistenceHelper;
import jp.sourceforge.sxdbutils.tiger.template.InsertTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractInsertTemplate<E>
implements InsertTemplate<E> {
    protected final QueryFactory insertFactory;
    protected EntityPersistenceHelper<E> persistenceHelper = new EntityPersistenceHelper();

    protected abstract Connection getConnection() throws SQLException;

    public AbstractInsertTemplate(QueryFactory insertFactory) {
        this.insertFactory = insertFactory;
    }

    @Override
    public int[] insert(Collection<E> entities) throws SQLException {
        return this.persistenceHelper.execute(this.getConnection(), this.insertFactory, entities);
    }

    @Override
    public int insert(E entity) throws SQLException {
        return this.persistenceHelper.execute(this.getConnection(), this.insertFactory, entity);
    }

    @Override
    public int[] insertBatch(Collection<E> entities) throws SQLException {
        return this.persistenceHelper.executeBatch(this.getConnection(), this.insertFactory, entities);
    }
}

