/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.tiger.rstable;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import jp.sourceforge.sxdbutils.tiger.rstable.ResultTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalCachedResultSet
implements ResultSet {
    private final ResultTable resultTable;
    private int index = -1;

    public LocalCachedResultSet(ResultTable resultTable) {
        this.resultTable = resultTable;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (row == 0) {
            this.index = -1;
            return false;
        }
        int n = this.index = row > 0 ? row - 1 : this.resultTable.size() - row - 1;
        return 0 <= this.index && this.index < this.resultTable.size();
    }

    @Override
    public void afterLast() throws SQLException {
        this.index = this.resultTable.size();
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.index = -1;
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean first() throws SQLException {
        return this.absolute(1);
    }

    @Override
    public Array getArray(int i) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        String string = this.resultTable.getString(this.index, columnIndex);
        return new ByteArrayInputStream(string.getBytes());
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        String string = this.resultTable.getString(this.index, columnName);
        return new ByteArrayInputStream(string.getBytes());
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bd = this.resultTable.getBigDecimal(this.index, columnIndex);
        bd.setScale(scale);
        return bd;
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        return this.resultTable.getBigDecimal(this.index, columnIndex);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        BigDecimal bd = this.resultTable.getBigDecimal(this.index, columnName);
        bd.setScale(scale);
        return bd;
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.resultTable.getBigDecimal(this.index, columnName);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        return new ByteArrayInputStream(this.resultTable.getBytes(this.index, columnIndex));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return new ByteArrayInputStream(this.resultTable.getBytes(this.index, columnName));
    }

    @Override
    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        return this.resultTable.getBoolean(this.index, columnIndex);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.resultTable.getBoolean(this.index, columnName);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        return this.resultTable.getByte(this.index, columnIndex);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.resultTable.getByte(this.index, columnName);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        return this.resultTable.getBytes(this.index, columnIndex);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.resultTable.getBytes(this.index, columnName);
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        return new StringReader(this.resultTable.getString(this.index, columnIndex));
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return new StringReader(this.resultTable.getString(this.index, columnName));
    }

    @Override
    public Clob getClob(int i) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        return this.getClass().getName();
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        return this.resultTable.getSqlDate(this.index, columnIndex);
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.resultTable.getSqlDate(this.index, columnName);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        return this.resultTable.getDouble(this.index, columnIndex);
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.resultTable.getDouble(this.index, columnName);
    }

    @Override
    public int getFetchDirection() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public int getFetchSize() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        return this.resultTable.getFloat(this.index, columnIndex);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.resultTable.getFloat(this.index, columnName);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        return this.resultTable.getInt(this.index, columnIndex);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.resultTable.getInt(this.index, columnName);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        return this.resultTable.getLong(this.index, columnIndex);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.resultTable.getLong(this.index, columnName);
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Object getObject(int i, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.resultTable.getObject(this.index, columnIndex);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.resultTable.getObject(this.index, columnName);
    }

    @Override
    public Ref getRef(int i) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public int getRow() throws SQLException {
        return this.index + 1;
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        return this.resultTable.getShort(this.index, columnIndex);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.resultTable.getShort(this.index, columnName);
    }

    @Override
    public Statement getStatement() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        return this.resultTable.getString(this.index, columnIndex);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.resultTable.getString(this.index, columnName);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        return this.resultTable.getTime(this.index, columnIndex);
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.resultTable.getTime(this.index, columnName);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        return this.resultTable.getTimestamp(this.index, columnIndex);
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.resultTable.getTimestamp(this.index, columnName);
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.index >= this.resultTable.size();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.index < 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.index == 0;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.resultTable.size() == this.index + 1;
    }

    @Override
    public boolean last() throws SQLException {
        return this.absolute(this.resultTable.size());
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean next() throws SQLException {
        return this.absolute(this.index + 2);
    }

    @Override
    public boolean previous() throws SQLException {
        return this.absolute(this.index);
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        return this.absolute(this.index + 1 + rows);
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("SQLFeatureNotSupportedException.");
    }

    @Override
    public boolean wasNull() throws SQLException {
        return false;
    }
}

