package jp.sourceforge.sxdbutils.tiger.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;

public abstract class AbstractInsertTemplate<E> implements InsertTemplate<E> {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory insertFactory;
	protected EntityPersistenceHelper<E> persistenceHelper = new EntityPersistenceHelper<E>();

	public AbstractInsertTemplate(QueryFactory insertFactory) {
		this.insertFactory = insertFactory;
	}

	public int[] insert(Collection<E> entities) throws SQLException {
		return persistenceHelper.execute(getConnection(), insertFactory, entities);
	}

	public int insert(E entity) throws SQLException {
		return persistenceHelper.execute(getConnection(), insertFactory, entity);
	}

	public int[] insertBatch(Collection<E> entities) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), insertFactory,
				entities);
	}

}
