package jp.sourceforge.sxdbutils.tiger.processors;

import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;
import jp.sourceforge.sxdbutils.tiger.util.Util;

/**
 * Beanにマッピングする {@link SxRowProcessor}。 カラム名とプロパティ名の名前が、 {@link NameMapping}
 * によって一致したものがマッピングされます。 デフォルトでは、カラム名でマッピングされます。
 * 
 * @author chinpei
 * 
 */
public class BeanRowProcessor<S>
		extends
		SxRowProcessorDelegate<S, jp.sourceforge.sxdbutils.processors.BeanRowProcessor> {

	public BeanRowProcessor(Class<S> beanClass) {
		super(new jp.sourceforge.sxdbutils.processors.BeanRowProcessor(
				beanClass));
	}

	public BeanRowProcessor(Class<S> beanClass, NameMapping nameMapping) {
		super(new jp.sourceforge.sxdbutils.processors.BeanRowProcessor(
				beanClass, nameMapping));
	}
	public Class<S> getBeanClass(){
		Class<S> result= Util.cast(this.delegate.getBaseClass());
		return result;
	}
	public Class<S> getBaseClass(){
		Class<S> result= Util.cast(this.delegate.getBaseClass());
		return result;
	}

}
