package jp.sourceforge.sxdbutils.meta;

import java.sql.ResultSet;
import java.sql.SQLException;

import jp.sourceforge.sxdbutils.ValueType;

public class BasicResultSetToObjectEntry implements ResultSetToObjectEntry {
	String columnName;
	ValueType valueType;
	int sqlType;
	int columnIndex;
	AttributeDescpriotr attributeDescpriotr;
	

	public BasicResultSetToObjectEntry(String columnName, ValueType valueType,
			int sqlType, int columnIndex,
			AttributeDescpriotr attributeDescpriotr) {
		this.columnName = columnName;
		this.valueType = valueType;
		this.sqlType = sqlType;
		this.columnIndex = columnIndex;
		this.attributeDescpriotr = attributeDescpriotr;
	}

	public String toString() {
		return "columnName=" + columnName + "; sqlType=" + sqlType
				+ "; descpritor=" + attributeDescpriotr.getName()
				+ "; resultReader=" + valueType.getClass().getName();
	}

	/* (non-Javadoc)
	 * @see jp.sourceforge.sxdbutils.meta.ResultSetToObjectEntry#set(java.lang.Object, java.sql.ResultSet)
	 */
	public void set(Object object, ResultSet rset) throws SQLException {
		attributeDescpriotr.write(object, valueType.getValue(rset,
				this.columnIndex));
	}

}
