package jp.sourceforge.sxdbutils.bean;

import java.lang.reflect.Method;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

/**
 * カラムプロパティ。
 * 
 * @author chinpei
 * @deprecated
 */
public class ColumnProperty implements PersistenceEntry {
	protected final String columnName;
	protected final Method getter;
	protected final ValueType valueType;

	public ColumnProperty(String columnName, Method getter, ValueType valueType) {
		this.columnName = columnName;
		this.getter = getter;
		this.valueType = valueType;
	}

	public Object read(Object bean) {
		return valueType.toBindParameterValue(ReflectionUtil.invoke(bean,
				getter));
	}

	/**
	 * @deprecated
	 * @return
	 */
	public Object readProperty(Object bean) {
		return this.read(bean);
	}

	public String getColumnName() {
		return columnName;
	}

	/**
	 * @deprecated
	 * @return
	 */
	public Method getGetter() {
		return getter;
	}

	public ValueType getValueType() {
		return valueType;
	}
}
