package jp.sourceforge.sxdbutils.template.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.template.EntityPersistenceHelper;

/**
 * 
 * @author chinpei
 * @deprecated
 */
public abstract class AbstractUpdateTemplate implements UpdateTemplate {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory updateFactory;
	protected EntityPersistenceHelper persistenceHelper = new EntityPersistenceHelper();

	public AbstractUpdateTemplate(QueryFactory updateFactory) {
		this.updateFactory = updateFactory;
	}

	public int[] update(Collection beans) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, beans);
	}

	public int update(Object bean) throws SQLException {
		return persistenceHelper.execute(getConnection(), updateFactory, bean);
	}

	public int[] updateBatch(Collection beans) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), updateFactory,
				beans);
	}
}
