package jp.sourceforge.sxdbutils.rstable;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

import jp.sourceforge.sxdbutils.util.OthersUtils;

public class BinaryColumn extends AbstractColumn/*<byte[]>*/{

	public BinaryColumn(int columnIndex, ResultColumnMetaData columnMeta) {
		super(columnIndex, columnMeta);
	}

	public Object valueOf(ResultSet rset) throws SQLException {
		InputStream in = null;
		try {
			in = rset.getAsciiStream(columnIndex + 1);
			if (in == null)
				return null;
			return OthersUtils.toByteArray(in);
		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			OthersUtils.closeQuietly(in);
		}
	}

	public BigDecimal getBigDecimal(Object[] rowdata) {
		return null;
	}

	public boolean getBoolean(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		return value != null;
	}

	public Boolean getBooleanObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return Boolean.valueOf(value != null);

	}

	public byte getByte(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return (byte) 0;
		return ((byte[]) value)[0];
	}

	public Byte getByteObject(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Byte(((byte[]) value)[0]);
	}

	public byte[] getBytes(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		return ((byte[]) value);
	}

	public char getChar(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return '\u0000';
		return new String(((byte[]) value)).charAt(0);
	}

	public Character getCharacter(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		if (value == null)
			return null;
		return new Character(new String(((byte[]) value)).charAt(0));
	}

	public Date getDate(Object[] rowdata) {
		return null;
	}

	public double getDouble(Object[] rowdata) {
		return 0d;
	}

	public Double getDoubleObject(Object[] rowdata) {
		return null;
	}

	public float getFloat(Object[] rowdata) {
		return 0f;
	}

	public Float getFloatObject(Object[] rowdata) {
		return null;
	}

	public int getInt(Object[] rowdata) {
		return 0;
	}

	public Integer getInteger(Object[] rowdata) {
		return null;
	}

	public long getLong(Object[] rowdata) {
		return 0L;
	}

	public Long getLongObject(Object[] rowdata) {
		return null;
	}

	public short getShort(Object[] rowdata) {
		return 0;
	}

	public Short getShortObject(Object[] rowdata) {
		return null;
	}

	public java.sql.Date getSqlDate(Object[] rowdata) {
		return null;
	}

	public String getString(Object[] rowdata) {
		Object value = rowdata[columnIndex];
		return new String(((byte[]) value));
	}

	public Time getTime(Object[] rowdata) {
		return null;
	}

	public Timestamp getTimestamp(Object[] rowdata) {
		return null;
	}

}
