package jp.sourceforge.sxdbutils.tiger.handlers;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;
import jp.sourceforge.sxdbutils.tiger.SxRowProcessor;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class ArrayHandler<S> implements SxResultSetHandler<S[]> {

	protected final SxRowProcessor<S> processor;
	protected final Class<S> type;

	public ArrayHandler(SxRowProcessor<S> processor, Class<S> type) {
		this.processor = processor;
		this.type=type;
	}

	protected SxRowProcessor<S> getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}
	protected Class<S> getType(){
		if (this.type == null) {
			throw new IllegalStateException("typeが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetTypeメソッドをオーバーライドしてください。");
		}
		return this.type;
	}

	@SuppressWarnings("unchecked")
	public S[] handle(ResultSet rs) throws SQLException {
		List<S> rows = createList();
		if (rs.next()) {
			SxRowProcessor<S> proc = getProcessor();
			proc.init(rs.getMetaData());
			do {
				rows.add(proc.process(rs));
			} while (rs.next());
		}
		return rows.toArray((S[]) Array.newInstance(getType(), rows.size()));
	}

	List<S> createList() {
		return new ArrayList<S>();
	}

}
