/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.mapping;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.sourceforge.sxdbutils.mapping.ColumnNameMapping;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.mapping.OverwriteNameMapping;
import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;

public class ConstantAnnoNameMapping
implements NameMapping {
    private static final NameMapping DEFAULT_COMVERSION = new ColumnNameMapping();
    private static final String ANNOTATION_SUFFIC = "_COLUMN";
    protected final OverwriteNameMapping delegateNameMapping;

    public ConstantAnnoNameMapping(Class beanClass) {
        this(beanClass, DEFAULT_COMVERSION);
    }

    public ConstantAnnoNameMapping(Class beanClass, NameMapping defaultNameMapping) {
        HashMap<String, String> columnToPropertyMap = new HashMap<String, String>();
        Field[] fields = this.getAnnotationFields(beanClass);
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            String propertyName = ReflectionUtil.removalSuffixFieldName(field, ANNOTATION_SUFFIC);
            String columnName = this.getColumnNameFromAnnotation(field);
            columnToPropertyMap.put(propertyName, columnName);
        }
        this.delegateNameMapping = new OverwriteNameMapping(columnToPropertyMap, defaultNameMapping);
    }

    protected final String getColumnNameFromAnnotation(Field field) {
        return ReflectionUtil.getString(field);
    }

    protected final Field[] getAnnotationFields(Class beanClass) {
        ArrayList list = new ArrayList();
        this.readAnnotationFieldsToList(beanClass, list);
        return list.toArray(new Field[list.size()]);
    }

    protected void readAnnotationFieldsToList(Class beanClass, List list) {
        if ("java.lang.Object".equals(beanClass.getName())) {
            return;
        }
        this.readAnnotationFieldsToList(beanClass.getSuperclass(), list);
        Field[] fields = beanClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!this.isColumnAnnotation(field)) continue;
            list.add(field);
        }
    }

    public String toIntermediateNameFromAttrName(String bindObjectName) {
        return this.delegateNameMapping.toIntermediateNameFromAttrName(bindObjectName);
    }

    public final Map createIntermediateMap() {
        return new CaseInsensitiveHashMap();
    }

    public String toIntermediateNameFromColumnName(String columnName) {
        return this.delegateNameMapping.toIntermediateNameFromColumnName(columnName);
    }

    public String toColumnNameFromAttrName(String bindObjectName) {
        return this.delegateNameMapping.toColumnNameFromAttrName(bindObjectName);
    }

    private boolean isColumnAnnotation(Field field) {
        if (!ReflectionUtil.isPublicStaticFinalString(field)) {
            return false;
        }
        return field.getName().endsWith(ANNOTATION_SUFFIC);
    }
}

