package jp.sourceforge.sxdbutils.template.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.SxRowProcessor;
/**
 * 
 * @author chinpei
 * @deprecated
 */
public abstract class AbstractCrudTemplate implements CrudTemplate {

	protected abstract Connection getConnection() throws SQLException;

	protected abstract Class getBeanClass();

	protected abstract SxRowProcessor createBeanProcessor(Class beanClass);

	protected class InsertTemplateImpl extends AbstractInsertTemplate {
		public InsertTemplateImpl(QueryFactory insertFactory) {
			super(insertFactory);
		}

		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class UpdateTemplateImpl extends AbstractUpdateTemplate {
		public UpdateTemplateImpl(QueryFactory updateFactory) {
			super(updateFactory);
		}

		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class DeleteTemplateImpl extends AbstractDeleteTemplate {
		public DeleteTemplateImpl(QueryFactory deleteFactory) {
			super(deleteFactory);
		}

		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected class SelectTemplateImpl extends AbstractSelectTemplate {

		protected SxRowProcessor createBeanProcessor(Class beanClass) {
			return AbstractCrudTemplate.this.createBeanProcessor(beanClass);
		}

		protected Class getBeanClass() {
			return AbstractCrudTemplate.this.getBeanClass();
		}

		protected Connection getConnection() throws SQLException {
			return AbstractCrudTemplate.this.getConnection();
		}
	}

	protected final SelectTemplate selectTemplate;
	protected final InsertTemplate insertTemplate;
	protected final UpdateTemplate updateTemplate;
	protected final DeleteTemplate deleteTemplate;

	public AbstractCrudTemplate(QueryFactory insertFactory,
			QueryFactory updateFactory, QueryFactory deleteFactory) {
		this.selectTemplate = new SelectTemplateImpl();
		this.insertTemplate = new InsertTemplateImpl(insertFactory);
		this.updateTemplate = new UpdateTemplateImpl(updateFactory);
		this.deleteTemplate = new DeleteTemplateImpl(deleteFactory);

	}

	public int[] delete(Collection beans) throws SQLException {
		return deleteTemplate.delete(beans);
	}

	public int delete(Object bean) throws SQLException {
		return deleteTemplate.delete(bean);
	}

	public int[] deleteBatch(Collection beans) throws SQLException {
		return deleteTemplate.deleteBatch(beans);
	}

	public int insert(Object bean) throws SQLException {
		return insertTemplate.insert(bean);
	}

	public int[] insert(Collection beans) throws SQLException {
		return insertTemplate.insert(beans);
	}

	public int[] insertBatch(Collection beans) throws SQLException {
		return insertTemplate.insertBatch(beans);
	}

	public Object executeQueryToBean(Query query, Class beanClass)
			throws SQLException {
		return selectTemplate.executeQueryToBean(query, beanClass);
	}

	public Object executeQueryToBean(Query query) throws SQLException {
		return selectTemplate.executeQueryToBean(query);
	}

	public List executeQueryToBeanList(Query query, Class beanClass)
			throws SQLException {
		return selectTemplate.executeQueryToBeanList(query, beanClass);
	}

	public List executeQueryToBeanList(Query query) throws SQLException {
		return selectTemplate.executeQueryToBeanList(query);
	}

	public int[] update(Collection beans) throws SQLException {
		return updateTemplate.update(beans);
	}

	public int update(Object bean) throws SQLException {
		return updateTemplate.update(bean);
	}

	public int[] updateBatch(Collection beans) throws SQLException {
		return updateTemplate.updateBatch(beans);
	}

}
