package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.SxQueryRunner;
import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.handlers.ListHandler;
import jp.sourceforge.sxdbutils.handlers.SingleHandler;

public abstract class AbstractSelectTemplate implements SelectTemplate {
	protected abstract Connection getConnection() throws SQLException;

	protected abstract Class getEntityClass();

	protected abstract SxRowProcessor createRowProcessor(Class entity);

	protected SingleHandler createSingleHandler(Class entityClass) {
		return new SingleHandler(createRowProcessor(entityClass));
	}

	protected ListHandler createListHandler(Class entityClass) {
		return new ListHandler(createRowProcessor(entityClass));
	}

	public Object executeQueryToEntity(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query,
				createSingleHandler(getEntityClass()));
	}

	public List executeQueryToEntityList(Query query) throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return (List)runner.query(getConnection(), query,
				createListHandler(getEntityClass()));
	}

	public Object executeQueryToEntity(Query query, Class entityClass)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.query(getConnection(), query,
				createSingleHandler(entityClass));
	}

	public List executeQueryToEntityList(Query query, Class entityClass)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return (List) runner.query(getConnection(), query,
				createListHandler(entityClass));
	}

}
