package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.template.EntityPersistenceHelper;

public abstract class AbstractDeleteTemplate implements DeleteTemplate {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory deleteFactory;
	protected EntityPersistenceHelper persistenceHelper = new EntityPersistenceHelper();

	public AbstractDeleteTemplate(QueryFactory deleteFactory) {
		this.deleteFactory = deleteFactory;
	}

	public int[] delete(Collection entities) throws SQLException {
		return persistenceHelper.execute(getConnection(), deleteFactory, entities);
	}

	public int delete(Object entity) throws SQLException {
		return persistenceHelper.execute(getConnection(), deleteFactory, entity);
	}

	public int[] deleteBatch(Collection entities) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), deleteFactory,
				entities);
	}

}
