package jp.sourceforge.sxdbutils.mapping;

import java.util.Map;

import jp.sourceforge.sxdbutils.util.CaseInsensitiveHashMap;
import jp.sourceforge.sxdbutils.util.NameConvertUtils;

/**
 * 中間マッピング名にカラム名を使用する {@link NameMapping}の実装です。
 * プロパティは、逆キャメル変換によってカラム名に変換されます。
 * 
 * @author chinpei
 * 
 */
public class CamelNameMapping implements NameMapping {
	public String toIntermediateNameFromAttrName(String bindObjectName) {
		return NameConvertUtils.camelToColumnName(bindObjectName);
	}
	public Map createIntermediateMap() {
		return new CaseInsensitiveHashMap();
	}
	public String toIntermediateNameFromColumnName(String columnName) {
		return columnName;
	}
	public String toColumnNameFromAttrName(String bindObjectName) {
		return NameConvertUtils.camelToColumnName(bindObjectName);
	}


}
