package jp.sourceforge.sxdbutils.mapping;

import java.util.Map;
/**
 * マッピングする「中間マッピング名」を生成する。
 * 
 * SxDbUtilsは、中間マッピング名が一致するカラムとプロパティをマッピングします。
 * 
 * @author chinpei
 * 
 */
public interface NameMapping {
	/**
	 * カラム名から中間マッピング名を生成する。
	 * 
	 * @param columnName
	 * @return
	 */
	String toIntermediateNameFromColumnName(String columnName);
	/**
	 * プロパティから中間マッピング名を生成する。
	 * 
	 * @param attrName
	 * @return
	 */
	String toIntermediateNameFromAttrName(String attrName);
	
	/**
	 * プロパティからカラム名を生成する。
	 * これはJava→DBへ登録する際に使用されます。
	 * 
	 * @param attrName
	 * @return
	 */
	String toColumnNameFromAttrName(String attrName);
	/**
	 * 中間マッピング名の一致に使われるMapを生成する。
	 * 
	 * @return
	 */
	Map createIntermediateMap();
}
