package jp.sourceforge.sxdbutils.types;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DoubleType extends AbstractValueType {
	private static final Double ZERO = new Double(0d);
	private final boolean primitive;

	public DoubleType(boolean primitive) {
		this.primitive = primitive;
	}

	public Object getValue(ResultSet rset, int columnIndex) throws SQLException {
		BigDecimal bd = rset.getBigDecimal(columnIndex);
		if (bd == null)
			return primitive ? ZERO : null;
		return new Double(bd.doubleValue());
	}
	// protected int getSqlType() {
	// return Types.DOUBLE;
	// }

}
