package jp.sourceforge.sxdbutils.template;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.template.EntityPersistenceHelper;

public abstract class AbstractInsertTemplate implements InsertTemplate {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory insertFactory;
	protected EntityPersistenceHelper persistenceHelper = new EntityPersistenceHelper();

	public AbstractInsertTemplate(QueryFactory insertFactory) {
		this.insertFactory = insertFactory;
	}

	public int[] insert(Collection entities) throws SQLException {
		return persistenceHelper.execute(getConnection(), insertFactory, entities);
	}

	public int insert(Object entity) throws SQLException {
		return persistenceHelper.execute(getConnection(), insertFactory, entity);
	}

	public int[] insertBatch(Collection entities) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), insertFactory,
				entities);
	}

}
