package jp.sourceforge.sxdbutils.query;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.mapping.NameMapping;
import jp.sourceforge.sxdbutils.meta.AttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.BasicPersistenceEntry;
import jp.sourceforge.sxdbutils.meta.FieldAttributeDescpriotr;
import jp.sourceforge.sxdbutils.meta.PersistenceEntry;

/**
 * AttributeQueryFactoryのビルダーです。
 * 
 * @author chinpei
 * 
 */
public class FieldQueryFactoryBuilder extends AttributeQueryFactoryBuilder {

	public FieldQueryFactoryBuilder(Class baseClass) {
		super(baseClass);
	}

	public FieldQueryFactoryBuilder(Class baseClass, NameMapping nameMapping) {
		super(baseClass, nameMapping);
	}

	public FieldQueryFactoryBuilder excludeColumn(String excludeColumn) {
		excludeColumns.add(excludeColumn.toLowerCase());
		return this;
	}

	public FieldQueryFactoryBuilder excludeColumns(String[] excludeColumns) {
		for (int i = 0; i < excludeColumns.length; i++)
			excludeColumn(excludeColumns[i]);
		return this;
	}

	public FieldQueryFactoryBuilder excludeColumns(List excludeColumns) {
		for (int i = 0; i < excludeColumns.size(); i++)
			excludeColumn((String) excludeColumns.get(i));
		return this;
	}

	public FieldQueryFactoryBuilder tableName(String tableName) {
		this.tableName = tableName;
		return this;
	}

	public FieldQueryFactoryBuilder versionColumnName(String versionColumnName) {
		this.versionColumnName = versionColumnName;
		return this;
	}

	public FieldQueryFactoryBuilder columnType(String columnName, int sqlType) {
		columnTypeMap.put(columnName.toLowerCase(), new Integer(sqlType));
		return this;
	}

	public FieldQueryFactoryBuilder whereKeyColumn(String columnNames) {
		if (this.whereKeyColumnSet == null) {
			this.whereKeyColumnSet = new LinkedHashSet();
		}
		this.whereKeyColumnSet.add(columnNames.toLowerCase());
		return this;
	}

	protected PersistenceEntry[] toPersistenceEntries() {

		Field[] fields = baseClass.getFields();

		List persistenceEntries = new ArrayList();
		for (int i = 0; i < fields.length; i++) {
			AttributeDescpriotr attributeDescpriotr = new FieldAttributeDescpriotr(
					fields[i]);
			String columnName = this.nameMapping
					.toColumnNameFromAttrName(attributeDescpriotr.getName());

			if (excludeColumns.contains(columnName.toLowerCase()))
				continue;

			// ValueType取得
			Integer sqlType = (Integer) columnTypeMap.get(columnName
					.toLowerCase());

			ValueType valueType = getValueType(attributeDescpriotr, sqlType);

			BasicPersistenceEntry entry = new BasicPersistenceEntry(columnName,
					valueType, attributeDescpriotr);

			persistenceEntries.add(entry);
		}
		return (PersistenceEntry[]) persistenceEntries
				.toArray(new PersistenceEntry[persistenceEntries.size()]);
	}

}
