package jp.sourceforge.sxdbutils.handlers;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.SxRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class ListHandler implements ResultSetHandler {

	protected final SxRowProcessor processor;

	public ListHandler(SxRowProcessor processor) {
		this.processor = processor;
	}

	public ListHandler() {
		this.processor = null;
	}

	protected SxRowProcessor getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		return this.processor;
	}

	public Object handle(ResultSet rs) throws SQLException {
		List rows = createList();
		if (rs.next()) {
			SxRowProcessor proc = getProcessor();
			proc.init(rs.getMetaData());
			do {
				rows.add(proc.process(rs));
			} while (rs.next());
		}
		return rows;
	}

	private List createList() {
		return new ArrayList();
	}

}
