package jp.sourceforge.sxdbutils.handlers;

import java.lang.reflect.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.SxRowProcessor;

import org.apache.commons.dbutils.ResultSetHandler;

/**
 * 複数行を処理するハンドラです。
 * 
 * @author chinpei
 * 
 */
public class ArrayHandler implements ResultSetHandler {

	protected final SxRowProcessor processor;
	protected final Class type;
	public ArrayHandler(SxRowProcessor processor,Class type) {
		this.processor = processor;
		this.type=type;
	}

	public ArrayHandler() {
		this.processor = null;
		this.type=null;
	}

	protected SxRowProcessor getProcessor() {
		if (processor == null) {
			throw new IllegalStateException("SxRowProcessorが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetProcessorメソッドをオーバーライドしてください。");
		}
		
		return this.processor;
	}
	protected Class getType() {
		if (this.type == null) {
			throw new IllegalStateException("typeが指定されていません。"
					+ "引数なしのコンストラクタを使用する場合、"
					+ "必ずgetTypeメソッドをオーバーライドしてください。");
		}
		
		return this.type;
	}
	public Object handle(ResultSet rs) throws SQLException {
		List rows = createList();
		if (rs.next()) {
			SxRowProcessor proc = getProcessor();
			proc.init(rs.getMetaData());
			do {
				rows.add(proc.process(rs));
			} while (rs.next());
		}
		return Array.newInstance(getType(), rows.size());
	}

	private List createList() {
		return new ArrayList();
	}

}
