package jp.sourceforge.sxdbutils.tiger.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.tiger.SxQueryRunner;

public class BeanPersistenceHelper<E> {

	public int execute(Connection connection, QueryFactory factory, E bean)
			throws SQLException {
		SxQueryRunner runner = new SxQueryRunner();
		return runner.update(connection, factory.toQuery(bean));
	}

	public int[] execute(Connection connection, QueryFactory factory,
			Collection<E> beans) throws SQLException {
		List<Query> queries = new ArrayList<Query>();
		for (E bean : beans) {
			Query q = factory.toQuery(bean);
			queries.add(q);
		}
		int[] result = new int[queries.size()];
		SxQueryRunner runner = new SxQueryRunner();
		for (int i = 0; i < queries.size(); i++) {
			result[i] = runner.update(connection, queries.get(i));
		}
		return result;

	}

	public int[] executeBatch(Connection connection, QueryFactory factory,
			Collection<E> beans) throws SQLException {
		Object[][] batchParams = new Object[beans.size()][];
		int i = 0;
		for (E bean : beans) {
			batchParams[i++] = factory.toBindParameters(bean);
		}
		SxQueryRunner runner = new SxQueryRunner();
		return runner.batch(connection, factory.getSql(), batchParams);
	}

}
