package jp.sourceforge.sxdbutils.template.bean;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;

import jp.sourceforge.sxdbutils.query.QueryFactory;
import jp.sourceforge.sxdbutils.bean.BeanPersistenceHelper;

public abstract class AbstractDeleteTemplate implements DeleteTemplate {

	protected abstract Connection getConnection() throws SQLException;

	protected final QueryFactory deleteFactory;
	protected BeanPersistenceHelper persistenceHelper = new BeanPersistenceHelper();

	public AbstractDeleteTemplate(QueryFactory deleteFactory) {
		this.deleteFactory = deleteFactory;
	}

	public int[] delete(Collection beans) throws SQLException {
		return persistenceHelper.execute(getConnection(), deleteFactory, beans);
	}

	public int delete(Object bean) throws SQLException {
		return persistenceHelper.execute(getConnection(), deleteFactory, bean);
	}

	public int[] deleteBatch(Collection beans) throws SQLException {
		return persistenceHelper.executeBatch(getConnection(), deleteFactory,
				beans);
	}

}
