/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sxdbutils.tiger;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import jp.sourceforge.sxdbutils.query.Query;
import jp.sourceforge.sxdbutils.tiger.SxResultSetHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SxQueryRunner
extends jp.sourceforge.sxdbutils.SxQueryRunner {
    public SxQueryRunner() {
    }

    public SxQueryRunner(DataSource ds) {
        super(ds);
    }

    public <S> S query(Connection conn, String sql, Object param, SxResultSetHandler<S> rsh) throws SQLException {
        return this.query(conn, sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <S> S query(Connection conn, String sql, Object[] params, SxResultSetHandler<S> rsh) throws SQLException {
        PreparedStatement stmt = null;
        ResultSet rs = null;
        S result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rs = this.wrap(stmt.executeQuery());
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return result;
            }
            finally {
                this.close(stmt);
            }
        }
        catch (SQLException e) {
            this.rethrow(e, sql, params);
            return result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
            }
        }
    }

    public <S> S query(Connection conn, String sql, SxResultSetHandler<S> rsh) throws SQLException {
        return this.query(conn, sql, null, rsh);
    }

    public <S> S query(String sql, Object param, SxResultSetHandler<S> rsh) throws SQLException {
        return this.query(sql, new Object[]{param}, rsh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> S query(String sql, Object[] params, SxResultSetHandler<S> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        try {
            S s = this.query(conn, sql, params, rsh);
            return s;
        }
        finally {
            this.close(conn);
        }
    }

    public <S> S query(Connection conn, Query query, SxResultSetHandler<S> rsh) throws SQLException {
        return this.query(conn, query.getSql(), query.getParameters(), rsh);
    }

    public <S> S query(Query query, SxResultSetHandler<S> rsh) throws SQLException {
        return this.query(query.getSql(), query.getParameters(), rsh);
    }

    public <S> S query(String sql, SxResultSetHandler<S> rsh) throws SQLException {
        return this.query(sql, (Object[])null, rsh);
    }
}

