package jp.sourceforge.sxdbutils.bean;

import java.lang.reflect.Method;

import jp.sourceforge.sxdbutils.ValueType;
import jp.sourceforge.sxdbutils.util.ReflectionUtil;
/**
 * カラムプロパティ。
 * @author chinpei
 *
 */
public class ColumnProperty {
	protected final String columnName;
	protected final Method getter;
	protected final ValueType valueType;

	public ColumnProperty(String columnName, Method getter, ValueType valueType) {
		this.columnName = columnName;
		this.getter = getter;
		this.valueType = valueType;
	}

	public Object readProperty(Object bean) {
		return valueType.toBindParameterValue(ReflectionUtil.invoke(bean,
				getter));
	}

	public String getColumnName() {
		return columnName;
	}

	public Method getGetter() {
		return getter;
	}

	public ValueType getValueType() {
		return valueType;
	}
	
}
