package jp.sourceforge.sxdbutils.processors;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

import jp.sourceforge.sxdbutils.SxRowProcessor;
import jp.sourceforge.sxdbutils.TypeMappings;
import jp.sourceforge.sxdbutils.ValueType;

/**
 * 
 * @author chinpei
 * 
 */
public class ArrayRowProcessor implements SxRowProcessor {

	protected ValueType[] valueTypes;

	/**
	 * 初期化。
	 */
	public void init(ResultSetMetaData rsmd) throws SQLException {

		List list = new ArrayList();

		for (int i = 0, columnIndex = 1; i < rsmd.getColumnCount(); i++, columnIndex++) {
			ValueType valueType = getValueType(rsmd.getColumnType(columnIndex));
			list.add(valueType);
		}
		this.valueTypes = (ValueType[]) list
				.toArray(new ValueType[list.size()]);

	}

	/**
	 * 結果を配列で返します。
	 */
	public Object process(ResultSet rs) throws SQLException {
		Object[] result = new Object[valueTypes.length];
		for (int i = 0; i < valueTypes.length; i++) {
			ValueType valueType = valueTypes[i];
			result[i] = valueType.getValue(rs, i + 1);
		}
		return result;
	}

	protected ValueType getValueType(int sqlType) {
		return TypeMappings.getValueType(sqlType);
	}

}
